<?php

namespace App\Http\Controllers\Api;

use App\Models\Branch;
use Illuminate\Http\Request;

class BranchesApiController extends BaseController
{
    //
    public function index()
    {
        $branches = Branch::with('manager','city')->get();
        return response([
            'success' => 1,
            'branches' => $branches
        ]);
    }

    public function show($id)
    {
        $branch = Branch::with('manager','city')->where('id',$id)->first();
        return response([
            'success' => 1,
            'branch' => $branch
        ]);
    }

    public function store(Request $request)
    {
        $request->validate([
            // 'id' => 'required',
            'email' => 'required',
            'name' => 'required',
            'phone' => 'required',
            'city_id' => 'required',
            'neighborhood_id' => 'required',
        ]);

        $branch = new Branch();
        $branch ->name = $request->name;
        $branch ->email = $request->email;
        $branch ->phone = $request->phone;
        $branch ->city_id = $request->city_id;
        $branch ->neighborhood_id = $request->neighborhood_id;
        if ($request->image) {
            $branch ->image = $request->image;
        }
        $branch -> save();
        return response(['branch' => $branch,'success' => 1]);
    }

    public function update(Request $request)
    {
        $request->validate([
            'id' => 'required',
            'email' => 'required',
            'name' => 'required',
            'phone' => 'required',
            'city_id' => 'required',
            'neighborhood_id' => 'required',
        ]);

        $branch = Branch::find($request->id);
        if ($branch == null) {
            return response([
                'success' => 0,
                'message' => 'Unknown Branch'
            ]);
        }
        $branch ->name = $request->name;
        $branch ->email = $request->email;
        $branch ->phone = $request->phone;
        $branch ->city_id = $request->city_id;
        $branch ->neighborhood_id = $request->neighborhood_id;
        if ($request->image) {
            $branch ->image = $request->image;
        }
        $branch -> save();
        return response(['branch' => $branch,'success' => 1]);
    }

    public function delete($id)
    {
        $branch = Branch::find($id);
        $branch->delete();
        return response([
            'success' => 1,
            'message' => 'Deleted successfully',
        ]);
    }

}
