<?php

namespace App\Http\Controllers\Api;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use App\Models\City;
use App\Models\Country;
use App\Models\IntercityRate;
use App\Models\Interzonerate;
use App\Models\Zone;

class CitiesApiController extends BaseController
{
    //
    public function index(Request $request)
    {
        if ($request->country_id==null) {
            $cities = City::with(['state','country'])->orderBy('name','ASC')->get();
        }else {
            $cities = City::where('country_id',$request->country_id)->with(['state','country'])->orderBy('name','ASC')->get();

        }
        $countries= Country::orderBy('name','ASC')->get();
        return response(['success' => 1, 'cities' => $cities,'countries' => $countries]);
    }

    public function getSupportedDeliveryCities()
    {
        $cities_id = [];
        $cities = [];
        $zones = Zone::all();
        foreach ($zones as $zone) {
            array_push($cities_id,$zone->city_id);
        }
	    $cities_id = array_unique($cities_id);

        $intercities = IntercityRate::all();
        foreach ($intercities as $intercity) {
            if (in_array($intercity->from_city_id,$cities_id)!=1) {
                array_push($cities_id,$intercity->from_city_id);
            }
            if (in_array($intercity->to_city_id,$cities_id)!=1) {
                array_push($cities_id,$intercity->to_city_id);
            }

        }
        foreach ($cities_id as $city_id) {
            $city = City::find($city_id);
            array_push($cities,$city);
        }

        return response(['cities' => $cities, 'success' => 1]);
    }
    // public function getCitiesByCountry(Request $request)
    // {
    //     $cities = City::where('country_id', $request->country_id)->get();
    //     return $this->successResponse($cities);
    // }


    // public function store(Request $request)
    // {
    //     try {

    //         $validator = Validator::make($request->all(), [
    //             'name' => 'required | string',
    //             'state_id' => 'required ',
    //             'country_id' => 'required ',
    //         ]);

    //         if ($validator->fails()) {
    //             return redirect()->back()->withInput()->with('error', $validator->messages()->first());
    //         };

    //         // store user information
    //         if ($this->save($request->only((new City())->getFillable()))) {
    //             return redirect()->back()->with('success', 'City created successfully!');
    //         } else {
    //             return redirect()->back()->with('error', 'Failed to create new City! Try again.');
    //         }
    //     } catch (\Exception $e) {
    //         $bug = $e->getMessage();

    //         return redirect()->back()->with('error', $bug);
    //     }
    // }

    // public function update(Request $request)
    // {
    //     // update tenant info
    //     $validator = Validator::make($request->all(), [
    //         'id' => 'required',
    //         'name' => 'required | string',
    //         'state_id' => 'required ',
    //         'country_id' => 'required ',
    //     ]);
    //     if ($validator->fails()) {
    //         return redirect()->back()->withInput()->with('error', $validator->messages()->first());
    //     }

    //     try {
    //         $city = City::find($request->id);

    //         $data = $request->only((new City())->getFillable());

    //         $update = $this->save($data, $city); //$category->update($data);

    //         if ($update) {
    //             return redirect()->back()->with('success', 'City information updated successfully !');
    //         } else {
    //             return redirect()->back()->with('error', 'Failed to update the City! Try again.');
    //         }
    //     } catch (\Exception $e) {
    //         $bug = $e->getMessage();

    //         return redirect()->back()->with('error', $bug);
    //     }
    // }

    // public function delete($id)
    // {
    //     $city = City::where('id', $id)->first();
    //     if ($city) {
    //         $city->delete();
    //         return redirect()->back()->with('success', 'city removed!');
    //     } else {
    //         return redirect()->back()->with('error', 'city not found');
    //     }
    // }

    // public function destroy($id)
    // {
    //     $city = City::withTrashed()->where('id', $id)->first();
    //     if ($city) {
    //         $city->forceDelete();
    //         return redirect()->back()->with('success', 'City removed!');
    //     } else {
    //         return redirect()->back()->with('error', 'City not found');
    //     }
    // }

    // public function save($data, $city = null)
    // {
    //     if(!$city){
    //         $city = new City();
    //     }

    //     $city->name = $data['name'];
    //     $city->state_id = $data['state_id'];
    //     $city->country_id = $data['country_id'];
    //     $city->save();

    //     return $city;
    // }
}
