<?php

namespace App\Http\Controllers\Api;

use App\Models\Customer;
use Illuminate\Http\Request;

class CustomerApiController extends BaseController
{
    //
    public function checkCustomer($id)
    {
        $customer = Customer::where('external_id',$id)->first();
        if ($customer) {
            return response(['customer' => $customer, 'success' => 1]);
        }
        return response(['success' => 0]);
    }

    public function store(Request $request)
    {
        $request->validate([
            // 'id' => 'required',
            'email' => 'required',
            'username' => 'required',
            'phone' => 'required',
        ]);

        $customer = new Customer();
        if ($request->id != null) {
            $customer ->external_id = $request->id;
        }
        if ($request->username != null) {
            $customer ->username = $request->username;
        }
        $customer ->first_name = $request->firstname;
        $customer ->last_name = $request->lastname;
        $customer ->email = $request->email;
        $customer ->phone = $request->phone;
        $customer ->country = 37;
        $customer -> save();
        return response(['customer' => $customer,'success' => 1]);
    }

    public function index()
    {
        $customers = Customer::all();
        return response(['success' => 1,'customers' => $customers]);
    }
}
