<?php

namespace App\Http\Controllers\Api;

use App\Mail\AccountCreated;
use App\Mail\ForgotPassword;
use App\Models\AgentEarning;
use App\Models\DeliveryAgent;
use App\Models\DeliveryAgentOrder;
use App\Models\DeliveryOrder;
use App\Models\JobCodTransaction;
use App\Models\OrderCommissionTransaction;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Mail;

class DeliveryAgentsApiController extends BaseController
{
    //
    public function store(Request $request)
    {
        $request->validate([
            'name' => 'required',
            // 'lastname' => 'required',
            'email' => 'required | unique:delivery_agents,email',
            'role' => 'required',
            'branch_id' => 'required',
            'phone' => 'required',
            'neighborhood_id' => 'required',
            'city_id' => 'required',
        ]);

        $agent = new DeliveryAgent();
        $agent->name = $request->name;
        // username
        if ($request->branch_id > 9) {
            $b_id = $request->branch_id;
        }else{

            $b_id = '0'. $request->branch_id;
        }
        $branch_agents = DeliveryAgent::where('branch_id',$request->branch_id)->count();
        if ($branch_agents >= 100) {
            $branch_agents  += 1;
            $username = "TDA".$b_id.$branch_agents;
        }

        if ($branch_agents > 10 && $branch_agents < 100  ) {
            $branch_agents  += 1;
            $username = "TDA".$b_id."0".$branch_agents;
        }

        if ($branch_agents < 10  ) {
            $branch_agents  += 1;
            $username = "TDA".$b_id."00".$branch_agents;
        }

        $agent->username = $username;
        $agent->email = $request->email;
        $agent->phone = $request->phone;
        $agent->branch_id = $request->branch_id;
        $agent->neighborhood_id = $request->neighborhood_id;
        $agent->city_id = $request->city_id;
        if ($request->img) {
            $agent->image = $request->img;
        }
        $password = generateRandomString();
        $agent->password = password_hash($password,PASSWORD_DEFAULT);
        $agent->save();

        Log::info("password generated for ". $request->name,['password' => $password]);
        // assign role
        $agent->assignRole($request->role);

        // send password to given mail
        Mail::to($agent->email)->send(new AccountCreated($password,$agent->firstname.' '.$agent->lastname,$username));
        //


        return response([
            'success' => 1,
            'agent' => $agent,
            'password' => $password
        ]);
    }

    public function index(Request $request)
    {
        if ($request->role == 'all') {
            $agents = DeliveryAgent::with('roles','permissions','branch','neighborhood','city')->get();
            return response([
                'success' => 1,
                'agents' => $agents,
            ]);
        }
        if ($request->role == 'internal-agents') {
           $role = 'INTERNAL DELIVERY AGENT';
        }elseif ($request->role == 'freelance-agents') {
            $role = 'FREELANCE DELIVERY AGENT';
        }else {
            return response([
                'success' => 0,
                'message' => 'Unknown role',
            ]);
        }
        $agents = DeliveryAgent::role($role)->with('roles','permissions','branch','neighborhood','city')->get();
        return response([
            'success' => 1,
            'agents' => $agents,
        ]);


    }

    public function show($id)
    {
        $agent = DeliveryAgent::with('roles','permissions','branch','neighborhood','city')->where('id',$id)->first();
        if ($agent != null) {
            return response([
                'agent' => $agent,
                'success' => 1
            ]);
        }
        return response([
            'success' => 0,
            'message' => 'Unknown agent'
        ]);
    }

    public function assignOrders(Request $request)
    {
        $request->validate([
            'orders' => 'required',
            'agent_id' => 'required'
        ]);

        foreach ($request->orders as $order) {
            $test = DeliveryAgentOrder::where('delivery_order_id',$order)->where('delivery_agent_id',$request->agent_id)->first();
            if ($test == null) {
                $agent_order = new DeliveryAgentOrder();
                $agent_order->delivery_agent_id = $request->agent_id;
                $agent_order->delivery_order_id = $order;
                // $agent_order->delivery_agent_datetime = date('Y-m-d H:i:s');
                $agent_order->assign_datetime = date('Y-m-d H:i:s');
                $agent_order->delivery_agent_response = 0;
                $agent_order->save();
            }
        }

        return response([
            'success' => 1,
            'message' => 'Orders Successfully assigned'
        ]);
    }

    public function orders($type)
    {
        $user = auth()->guard('agent')->user();
        switch ($type) {
            case 'all':
                $orders = DeliveryAgentOrder::with('delivery_agent','delivery_order')
                ->whereHas('delivery_agent', function ($query) use ($user)
                {
                    $query->where('id',$user->id);
                })
                ->where('accepted_elsewhere',0)
                ->get();
                break;
            case 'waiting':
                $orders = DeliveryAgentOrder::with('delivery_agent','delivery_order')
                ->whereHas('delivery_agent', function ($query) use ($user)
                {
                    $query->where('id',$user->id);
                })
                ->where('delivery_agent_response',0)
                ->where('accepted_elsewhere',0)
                ->get();
                break;
            case 'accepted':
                $orders = DeliveryAgentOrder::with('delivery_agent','delivery_order')
                ->whereHas('delivery_agent', function ($query) use ($user)
                {
                    $query->where('id',$user->id);
                })
                ->where('accepted_elsewhere',0)
                ->where('delivery_agent_response',1)
                ->whereIn('delivery_agent_response',[1,3,4,5,6,7])
                ->get();
                break;

            default:
                return response([
                    'success' => 0,
                    'message' => 'Unknown Type'
                ]);
                break;
        }

        return response([
            'orders' => $orders,
            'success' => 1,
        ]);
    }

    public function changeOrderStatus(Request $request)
    {
        $request->validate([
            'status' => 'required',
            'agent_order_id' => 'required',
        ]);

        $max = false;
        $order = DeliveryAgentOrder::with('delivery_order')->where('id',$request->agent_order_id)->first();
        // $order->status = $request->status;
        switch ($request->status) {
            case 1:
                $agent_pending_orders = DeliveryAgentOrder::where('delivery_agent_id', '=',$order->delivery_agent_id)->whereIn('delivery_agent_response',[1,3,4,5])->count();
                if ($agent_pending_orders>=3) {
                    $max = true;
                }else {
                    $order->delivery_agent_datetime = date('Y-m-d H:i:s');
                    $order->delivery_agent_response =1;
                }
                break;
            case 2:
                $order->delivery_agent_datetime = date('Y-m-d H:i:s');
                $order->delivery_agent_response = 2;
                break;
            case 3:
                $order->on_the_way_to_pickup = date('Y-m-d H:i:s');
                $order->delivery_agent_response =3;
                break;
            case 4:
                $order->pickup_datetime = date('Y-m-d H:i:s');
                $order->delivery_agent_response =4;
                break;
            case 5:
                $order->on_the_way_to_dropoff = date('Y-m-d H:i:s');
                $order->delivery_agent_response =5;
                break;
            case 6:
                $order->delivered = date('Y-m-d H:i:s');
                $order->delivery_agent_response =6;
                // modify on delivery orders table here

                // assign commissions
                $agent_earning = new AgentEarning();
                $agent_earning->delivery_order_id = $order->delivery_order->id;
                $agent_earning->delivery_agent_id = auth()->guard('agent')->user()->id;
                $agent_earning->type = '+';
                $agent_earning->amount = env('AGENT_COMMISSION_PERCENTAGE') * $order->delivery_order->total;
                $agent_earning->post_balance = auth()->guard('agent')->user()->balance + (env('AGENT_COMMISSION_PERCENTAGE') * $order->delivery_order->total);
                $agent_earning->save();

                // delivery agent balance on that table
                $agent =DeliveryAgent::find(auth()->guard('agent')->user()->id);
                $agent->balance += env('AGENT_COMMISSION_PERCENTAGE') * $order->delivery_order->total;
                $agent->save();

                // update job_cod_table
                $job_cod = JobCodTransaction::where('delivery_order_id',$order->delivery_order->id)->first();
                $job_cod->status = 0;
                $job_cod->save();

                // update commissions table
                $commission = OrderCommissionTransaction::where('delivery_order_id',$order->delivery_order->id)->first();
                $commission->status = 0;
                $commission->save();
                break;

            default:
                return response([
                    'success' => 0,
                    'message' => 'Unknown Status type'
                ]);
                break;
        }
        $order->save();

        // modify other orders to say order was accepted somewhere
        if (!$max) {
            $other_same_orders = DeliveryAgentOrder::where('delivery_order_id',$order->delivery_order_id)->where('id','!=',$order->id)->get();

            foreach ($other_same_orders as $key) {
                $other_order = DeliveryAgentOrder::find($key->id);
                $other_order->accepted_elsewhere = 1;
                $other_order->save();
            }
            return response([
                'success' => 1,
                'message' => 'Status changed successfully'
            ]);
        }else {
            return response([
                'success' => 0,
                'message' => 'Maximum limit for accepted deliveries reached, please complete other deliveries first'
            ]);
        }

    }

    public function invitations()
    {
        $invitations = DeliveryAgentOrder::with('delivery_agent','delivery_order')->orderBy('created_at','DESC')->get();

        return response([
            'invitations' => $invitations,
            'success' => 1
        ]);
    }


}

