<?php

namespace App\Http\Controllers\Api;

use App\Models\Customer;
use App\Models\DeliveryJob;
use App\Models\DeliveryJobOrder;
use App\Models\DeliveryOrder;
use Illuminate\Http\Request;

class DeliveryJobsApiController extends BaseController
{
    //
    public function store(Request $request)
    {
        $request->validate([
            'customer_id' => 'required',
            'description' => 'required',
        ]);

        $job = new DeliveryJob();
        $job->customer_id = $request->customer_id;
        $job->description = $request->description;
        $code_condition = false;
        $code = "";
        while($code_condition == false){
         $code = generateRandomString();
         $test_code = DeliveryJob::where('code',$code)->first();
         if($test_code == null){
          $code_condition = true;
         }
        }
        $job->code = $code;
        $job->save();
        return response(['success' => 1,'job'=>$job]);
    }

    public function index($id)
    {
        $customer = Customer::where('external_id',$id)->first();
        if (!$customer) {
            return response(['success' => 2,'message'=>'Customer not found on table']);
        }
        $jobs = DeliveryJob::with('job_orders','job_cod_transaction')->where('customer_id',$customer->id)->get();
        return response(['success' => 1,'jobs'=>$jobs]);
    }


    public function show($id)
    {
        // id here is job_id
        $job = DeliveryJob::with('job_orders','customer','job_cod_transaction')->where('id',$id)->first();
        return response(['success' => 1,'job'=>$job]);
    }

    public function allJobs()
    {
        $jobs = DeliveryJob::with('job_orders','customer','job_cod_transaction')->orderBy('created_at','DESC')->get();
        return response(['success' => 1,'jobs'=>$jobs]);
    }

    public function assignJobOrders(Request $request)
    {
        $request->validate([
            'job_id' => '',
            'orders' => '',
        ]);

        $delivery_job = DeliveryJob::find($request->job_id);
        if (!$delivery_job) {
            return response(['success' => 0,'message'=>'Unknown Job']);
        }

        foreach ($request->orders as $order) {
            $jobOrder = new DeliveryJobOrder();
            $jobOrder->delivery_job_id = $request->job_id;
            $jobOrder->delivery_order_id = $order;
            $jobOrder->save();

            $delivery_order = DeliveryOrder::find($order);
            $delivery_order->status = 4;
            $delivery_order->save();

            $delivery_job->total_jobs += 1;
            $delivery_job->jobs_pending += 1;
            $delivery_job->save();
        }

        return response(['success' => 1,'message'=>'Orders Successfully assigned']);
    }


}
