<?php

namespace App\Http\Controllers\Api;;

use App\Models\Branch;
use App\Models\Customer;
use App\Models\CustomerReceiver;
use App\Models\CustomerSender;
use App\Models\DeliveryAgent;
use App\Models\DeliveryAgentOrder;
use App\Models\DeliveryJob;
use App\Models\DeliveryJobOrder;
use App\Models\DeliveryOrder;
use App\Models\JobCodTransaction;
use App\Models\OrderCommissionTransaction;
use Illuminate\Http\Request;

class DeliveryOrderApiController extends BaseController
{
    //
    public function store(Request $request)
    {

        $request->validate([
            'customer_id' => 'required',
            // 'type' => 'required',
            // sender info
            'sender_name' => 'required',
            'sender_phone' => 'required',
            'sender_email' => 'required',
            'sender_city' => 'required',
            'sender_neighborhood' => 'required',

            // receiver info
            'receiver_name' => 'required',
            'receiver_phone' => 'required',
            'receiver_city' => 'required',
            // 'receiver_neighborhood' => 'required',

            // delivery order info

            'service_type' => 'required',
            'good_type_id' => 'required',
            'delivery_type' => 'required',
            'parcel_value' => 'required',
            'parcel_title' => 'required',
            'parcel_description' => 'required',
            'pickup_datetime' => 'required',
            'delivery_fee' => 'required',
            // 'cod' => 'required',
            'instructions' =>'required',
        ]);



        // sender info
        $customer_sender = new CustomerSender();
        $customer_sender->customer_id = $request->customer_id;
        $customer_sender->type = 1;
        $customer_sender->name = $request->sender_name;
        $customer_sender->email = $request->sender_email;
        $customer_sender->phone = $request->sender_phone;
        $customer_sender->city = $request->sender_city;
        $customer_sender->neighborhood = $request->sender_neighborhood;
        $customer_sender->country = 37;
        $customer_sender->default = 0;
        $customer_sender ->save();


        // receiver info
        $customer_receiver = new CustomerReceiver();
        $customer_receiver->customer_id = $request->customer_id;
        $customer_receiver->type = 1;
        $customer_receiver->name = $request->receiver_name;
        if ($request->receiver_email != null) {
            $customer_receiver->email = $request->receiver_email;
        }
        $customer_receiver->phone = $request->receiver_phone;
        $customer_receiver->city = $request->receiver_city;
        if($request->receiver_neighborhood != null) {
            $customer_receiver->neighborhood = $request->receiver_neighborhood;
        }
        $customer_receiver->country = 37;
        $customer_receiver->default = 0;
        $customer_receiver ->save();

        // delivery order

        $order = new DeliveryOrder();
        $order->customer_id = $request->customer_id;
        $order->service_type = $request->service_type;
        $order->good_type_id = $request->good_type_id;
        $order->delivery_type = $request->delivery_type;
        $order->parcel_value = $request->parcel_value;
        $order->delivery_fee = $request->delivery_fee;
        $order->discount = 0;
        $order->cod = $request->cod;
        if ($request->cod == 0 || $request->cod == false) {
            $order->total = $request->delivery_fee;
        }else {
            $order->total = $request->delivery_fee + $request->parcel_value;
        }
        $order->parcel_title = $request->parcel_title;
        $order->parcel_description = $request->parcel_description;
        $order->pickup_datetime = $request->pickup_datetime;
        $order->delivery_datetime = $request->delivery_datetime;
        $order->parcel_description = $request->parcel_description;
        if ($request->pickup_gallery) {
            $order->parcel_gallery = $request->pickup_gallery;
        }
        if ($request->discount) {
            $order->discount = $request->discount;
        }
        $order->instructions = $request->instructions;
        $order->customer_sender_id = $customer_sender->id;
        $order->customer_receiver_id = $customer_receiver->id;
        // if ($request->assigned != null && $request->assigned == 1){
        //     $order->status = 4;
        // }
        $code_condition = false;
        $code = "";
        while($code_condition == false){
         $code = generateRandomString();
         $test_code = DeliveryOrder::where('code',$code)->first();
         if($test_code == null){
          $code_condition = true;
         }
        }
        $order->code = $code;
        $order->save();

        if ($request->assigned != null && $request->assigned == 1) {
            // assign to job order
            $job_order = new DeliveryJobOrder();
            $job_order->delivery_job_id = $request->job_id;
            $job_order->delivery_order_id = $order->id;
            $job_order->save();
            // modify job info
            $job = DeliveryJob::find($request->job_id);
            $job->total_jobs += 1;
            $job->jobs_pending += 1;
            $job->save();

            // create transactions
            // job_cod
            $job_cod = new JobCodTransaction();
            $job_cod->delivery_job_id = $request->job_id;
            $job_cod->delivery_order_id = $order->id;
            $job_cod->customer_id = $request->customer_id;
            $job_cod->amount_deposited = $order->total;
            $job_cod->status = -1;
            $job_cod->remark = 'AWAITING DELIVERY';
            $job_cod->save();
            // commissions
            $commission = new OrderCommissionTransaction();
            $commission->delivery_order_id = $order->id;
            $commission->referral_commission = env('REFERRAL_COMMISSIONS');
            $commission->system_commission = env('SYSTEM_COMMISSION');
            $commission->status = -1;
            $commission->remark = 'AWAITING DELIVERY';
            $commission->save();
        }

        // send delivery agents invitations
        $this->sendDeliveryOrderInvitation($request->sender_neighborhood,$order->id);
        //
        return response([
            'success' => 1,
            'message' => 'Order created Successfully',
            'order' => $order
        ]);

    }

    public function index(Request $request)
    {
        if ($request->customer_id == null) {
            return response(['success' => 0,'message' => 'missing member id']);
        }

        $customer = Customer::find($request->customer_id);
        if (!$customer) {
            return response(['message'=>'Unknown User','success'=>0]);
        }

        $orders = DeliveryOrder::with('sender','receiver','good_type')->where('customer_id',$request->customer_id)->orderBy('created_at','DESC')->get();

        return response(['success'=> 1,'orders' => $orders]);
    }

    public function show($id)
    {
        $order = DeliveryOrder::with('delivery_job','sender','receiver','good_type','customer','delivery_agent','delivery_agent_order')
        // ->whereHas('delivery_agent_order', function ($query) {
        //     $query->where('accepted_elsewhere',0);
        // })
        ->where('id',$id)->first();
        if ($order) {
            return response(['success'=> 1,'order' => $order]);
        }
        return response(['success'=> 0,'message'=>'Order not found']);
    }

    public function orderTypes(Request $request,$type)
    {
        $branch_id = "";
        switch ($type) {
            case 'all':
                if ($request->role != null && $request->role == 'manager') {
                    $branch_id = $request->branch_id;
                    $orders = DeliveryOrder::with('delivery_job','sender','receiver','good_type','customer','delivery_agent')
                    ->whereHas('delivery_agent',function ($query) use ($branch_id)
                    {
                        $query->where('branch_id',$branch_id);
                    })
                    ->orderBy('created_at','DESC')->get();
                }else {
                    $orders = DeliveryOrder::with('delivery_job','sender','receiver','good_type','customer','delivery_agent') ->orderBy('created_at','DESC')->get();
                }
                break;
            case 'pending':
                if ($request->role != null && $request->role == 'manager') {
                    $orders = DeliveryOrder::with('delivery_job','sender','receiver','good_type','customer','delivery_agent')
                    ->whereHas('delivery_agent',function ($query) use ($branch_id)
                    {
                        $query->where('branch_id',$branch_id);
                    })
                    ->orderBy('created_at','DESC')->where('status',0)->get();
                }else {
                    $orders = DeliveryOrder::with('delivery_job','sender','receiver','good_type','customer')->where('status',0)->get();
                }
                break;

            default:
            return response(['success'=> 0,'message' => 'Unknown Type']);
                break;
        }

        return response(['success'=> 1,'orders' => $orders]);

    }

    public function sendDeliveryOrderInvitation($pickup_location,$order_id)
    {
        $branch = Branch::where('neighborhood_id',$pickup_location)->first();
        if ($branch == null) {
            $agents = DeliveryAgent::where([
                ['neighborhood_id','=',$pickup_location],
                // ['branch_id','=',$branch->id],
            ])->get();
        }else{
            $agents = DeliveryAgent::where([
                ['neighborhood_id','=',$pickup_location],
                ['branch_id','=',$branch->id],
            ])->get();
        }

        foreach ($agents as $agent) {
            $test_agent_orders = DeliveryAgentOrder::where('delivery_agent_id', $agent->id)->whereIn('delivery_agent_response',[1,3,4,5])->count();
            if ($test_agent_orders < 4) {
                $agent_order = new DeliveryAgentOrder();
                $agent_order->delivery_agent_id = $agent->id;
                $agent_order->delivery_order_id = $order_id;
                $agent_order->assign_datetime = date('Y-m-d H:i:s');
                $agent_order->delivery_agent_response = 0;
                $agent_order->save();
            }

        }
        return true;
    }


}
