<?php

namespace App\Http\Controllers\Api;

use App\Models\GoodType;
use Illuminate\Http\Request;

class GoodsTypeApiController extends BaseController
{
    //
    public function index()
    {
        $good_types = GoodType::all();
        return response(['good_types' =>$good_types,'success' => 1]);
    }
    public function goodType($id)
    {
        $good_type = GoodType::find($id);
        if(!$good_type){
        return response(['message'=>'Unknown parce_typel','success'=>0]);
        }
        return response(['good_type'=>$good_type ,'success' => 1]);
    }

    public function store(Request $request)
    {
        $request->validate([
            'name' => 'required',
            // 'description' => 'required',
        ]);

        $good_type = new GoodType();
        $good_type->name = $request->name;
        if($request->description){
            $good_type->description = $request->description;
        }
        $good_type->save();
        return response([
            'success' => 1,
            'good_type' => $good_type
        ]);
    }

    public function update(Request $request)
    {
        $request->validate([
            'name' => 'required',
            // 'description' => 'required',
        ]);

        $good_type = GoodType::find($request->id);
        if ($good_type == null) {
            return response(['message'=>'Unknown parce_typel','success'=>0]);
        }

        $good_type->name = $request->name;
        if($request->description){
            $good_type->description = $request->description;
        }
        $good_type->save();
        return response([
            'success' => 1,
            'good_type' => $good_type
        ]);
    }

    public function delete($id)
    {
        $good_type = GoodType::find($id);
        $good_type->delete();
        return response([
            'success' => 1,
            'message' => 'Deleted successfully',
        ]);
    }

}
