<?php

namespace App\Http\Controllers\Api;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use App\Models\City;
use App\Models\Country;
use App\Models\Neighborhood;
use App\Models\State;

class NeighborhoodApiController extends BaseController
{
    //
    public function index(Request $request)
    {
        if ($request->city_id==null) {
            $Neighborhoods = Neighborhood::with('city','zones')->orderBy('name','ASC')->get();
            $city = null;
        }else {
            $Neighborhoods = Neighborhood::where('city_id',$request->city_id)->with('city','zones')->orderBy('name','ASC')->get();
            $city = City::find($request->city_id);

        }
        return response(['neighborhoods' => $Neighborhoods, 'city' => $city,'success' => 1]);
    }

    public function neighborhood($id)
    {
        $neighborhood= Neighborhood::with('city')->where('id',$id)->first();
        if (!$neighborhood) {
            return response(['message' => 'Neighborhood not found','success' => 0]);
        }

        return response(['neighborhood' => $neighborhood, 'success' => 1]);
    }

    public function store(Request $request)
    {
        $request->validate([
            'name' => 'required',
            'city_id' => 'required',
        ]);

        $neighborhood = new Neighborhood();
        $neighborhood->name = $request->name;
        $neighborhood->city_id = $request->city_id;
        $neighborhood->save();
        return response([
            'success' => 1,
            'neighborhood' => $neighborhood
        ]);
    }

    public function update(Request $request)
    {
        $request->validate([
            'id' => 'required',
            'name' => 'required',
            'city_id' => 'required',
        ]);

        $neighborhood = Neighborhood::find($request->id);
        if ($neighborhood == null) {
            return response([
                'success' => 0,
                'Message' => 'Unknown Neighborhood'
            ]);
        }
        $neighborhood->name = $request->name;
        $neighborhood->city_id = $request->city_id;
        $neighborhood->save();
        return response([
            'success' => 1,
            'neighborhood' => $neighborhood
        ]);
    }

    public function delete($id)
    {
        $neighborhood = Neighborhood::find($id);
        $neighborhood->delete();
        return response([
            'success' => 1,
            'message' => 'Deleted successfully',
        ]);
    }


}
