<?php

namespace App\Http\Controllers\Api;

use App\Models\IntercityRate;
use App\Models\Neighborhood;
use GrahamCampbell\ResultType\Success;
use Illuminate\Http\Request;

class PriceApiController extends BaseController
{
    //
    public function index(Request $request)
    {
        /*
        return 'types'
        1 - same city same neighborhood zone
        2- same city different neighborhood zone
        3- different cities- door to door
        4- different cities- package left at agency


        */
        // delivery neighborhood exists?
        if ($request->receiver_neighborhood != null && $request->receiver_neighborhood != 'null') {
            // are pickup and delivery locations in same city?
            if ($request->receiver_city == $request->sender_city) {
                // check if in same zone
                $zone = sameZone($request->sender_neighborhood, $request->receiver_neighborhood);
                $success = $zone['success'];
                if ($zone['success'] == 1) {
                    return response(['prices' => $zone['zone'],'success' => 1, 'type' => 1]);
                }

                if ($success == 0) {
                    $prices = getPricingInterzone($request->sender_neighborhood, $request->receiver_neighborhood);
                        switch ($prices['success']) {
                            case 0:
                                return response(['message' => $prices['message'],'success' => 0]);
                                break;
                            case 1:
                                return response(['prices'=>$prices['prices'],'success' => 1,'type'=> 2]);
                                break;

                            case -1:
                                return response(['message' => $prices['message'],'success' => 0]);
                                break;

                            default:
                                # code...
                                break;
                        }
                }

                if ($zone['success'] == -1) {
                    return response(['message' => $zone['message'],'success' => 0]);
                }

            }else {
                // different cities
                $pickup_zone = Neighborhood::with('zones')->where('id',$request->sender_neighborhood)->first();
                $delivery_zone = Neighborhood::with('zones')->where('id',$request->receiver_neighborhood)->first();
                $intercity_rates = IntercityRate::where('good_type_id',$request->parcel_type)->where('from_city_id',$request->sender_city)->where('to_city_id',$request->receiver_city)->get();

                return response([
                    'prices'=>[
                        'pickup_zone' => $pickup_zone,
                        'delivery_zone' => $delivery_zone,
                        'intercity_rates' => $intercity_rates,
                    ],
                    'success' => 1,
                    'type' => 3
                ]);
            }
        }else {
            // intercity but delivery neighborhood not defined
            $pickup_zone = Neighborhood::with('zones')->where('id',$request->sender_neighborhood)->first();
            $intercity_rates = IntercityRate::where('good_type_id',$request->parcel_type)->where('from_city_id',$request->sender_city)->where('to_city_id',$request->receiver_city)->get();

            return response([
                'prices'=>[
                    'pickup_zone' => $pickup_zone,
                    'intercity_rates' => $intercity_rates,
                ],
                'success' => 1,
                'type' => 4
            ]);
        }
    }
}
