<?php

namespace App\Http\Controllers\Api;

use App\Models\DeliveryAgent;
use App\Models\User;
use Illuminate\Http\Request;

class UserApiController extends BaseController
{
    //
    public function profile(Request $request)
    {
        $user = auth()->guard($request->role)->user(); 

        if ($request->role == 'agent') {
            $user = DeliveryAgent::with('roles','permissions','city','neighborhood')->where('id',$user->id)->first();
        }else {
            $user = User::with('roles','permissions','branch')->where('id',$user->id)->first();
        }

        return response([
            'success' => 1,
            'user' => $user
        ]);
    }
}
