<?php

namespace App\Http\Controllers\Api;

use App\Models\City;
use App\Models\IntercityRate;
use App\Models\Interzonerate;
use App\Models\Zone;
use App\Models\ZoneNeighborhood;
use Faker\Provider\Base;
use Illuminate\Http\Request;

class ZonesApiController extends BaseController
{
    //
    public function index()
    {
        # code...
        $zones = Zone::with(['cities','neighborhoods'])->get();
        return response(['success' => 1, 'zones' => $zones]);
    }

    public function show($id)
    {
        $zone = Zone::with(['cities','neighborhoods'])->where('id',$id)->first();
        if ($zone) {
            return response(['success' => 1, 'zone' => $zone]);
        }else {
            return response(['success' => 0, 'message' => 'Unknown zone']);
        }
    }

    public function zonesByCity($city_id)
    {
        $city = City::find($city_id);
        if ($city) {
            $zones = Zone::with(['cities','neighborhoods'])->where('city_id',$city_id)->get();
            return response(['success' => 1, 'zones' => $zones]);
        }
        return response(['success' => 0, 'message' => 'Unknown City']);
        # code...
    }

    public function store(Request $request)
    {
        $request->validate([
            'name' => 'required',
            'city_id' => 'required',
            'regular_rate' => 'required',
            'express_rate' => 'required',
        ]);

        $zone = new Zone();
        $zone->name = $request->name;
        $zone->city_id = $request->city_id;
        $zone->regular_rate = [
            'value' => $request->regular_rate,
            'currency' => 'XAF'
        ];
        $zone->express_rate = [
            'value' => $request->express_rate,
            'currency' => 'XAF'
        ];

        $zone->save();
        return response([
            'success' => 1,
            'zone' => $zone
        ]);
    }

     public function update(Request $request)
    {
        $request->validate([
            'id' => 'required',
            'name' => 'required',
            'city_id' => 'required',
            'regular_rate' => 'required',
            'express_rate' => 'required',
        ]);

        $zone = Zone::find($request->id);
        if ($zone==null) {
            return response([
                'success' => 0,
                'message' => 'Unknown Zone'
            ]);
        }
        $zone->name = $request->name;
        $zone->city_id = $request->city_id;
        $zone->regular_rate = [
            'value' => $request->regular_rate,
            'currency' => 'XAF'
        ];
        $zone->express_rate = [
            'value' => $request->express_rate,
            'currency' => 'XAF'
        ];

        $zone->save();
        return response([
            'success' => 1,
            'zone' => $zone
        ]);
    }

    public function delete($id)
    {
        $zone = Zone::find($id);
        $zone->delete();
        return response([
            'success' => 1,
            'message' => 'Deleted successfully',
        ]);
    }

    public function assignNeighborhoodsToZone(Request $request)
    {
        $request->validate([
            'zone_id' => 'required',
            'neighborhoods' => 'required',
        ]);

        foreach ($request->neighborhoods as $neighborhood) {
            $test = ZoneNeighborhood::where('zone_id',$request->zone_id)->where('neighborhood_id',$neighborhood)->first();
            if ($test == null) {

                $zoneNeighborhood = new ZoneNeighborhood();
                $zoneNeighborhood->zone_id = $request->zone_id;
                $zoneNeighborhood->neighborhood_id = $neighborhood;
                $zoneNeighborhood->save();
            }
        }
        return response([
            'success' => 1,
            'message' => 'assigned neighborhoods to Zone successfully'
        ]);
    }

    public function getInterzoneRates()
    {
        $interzoneRates = Interzonerate::with('fromZone','toZone')->get();
        return response([
            'success' => 1,
            'interzoneRates' => $interzoneRates,
        ]);
    }
    public function getIntercityRates()
    {
        $intercityRates = IntercityRate::with('from_city','to_city','good_type')->get();
        return response([
            'success' => 1,
            'intercityRates' => $intercityRates,
        ]);
    }

    public function interzoneRate($id)
    {
        $interzoneRate = Interzonerate::find($id);
        return response([
            'success' => 1,
            'interzoneRate' => $interzoneRate,
        ]);
    }
    public function intercityRate($id)
    {
        $intercityRate = IntercityRate::find($id);
        return response([
            'success' => 1,
            'intercityRate' => $intercityRate,
        ]);
    }

    public function storeInterzoneRates(Request $request)
    {
        $request->validate([
            'dep_zone'=>'required',
            'arr_zone'=>'required',
            'regular'=>'required',
            'express'=>'required',
        ]);

        $test = Interzonerate::where('from_zone_id',$request->dep_zone)->where('to_zone_id',$request->arr_zone)->first();

        if ($test) {
            return response([
                'success' => 0,
                'message' => 'Rates already set'
            ]);
        }

        $rate = new Interzonerate();
        $rate->from_zone_id = $request->dep_zone;
        $rate->to_zone_id = $request->arr_zone;
        $rate->regular_rate = [
            'value' => $request->regular,
            'currency' => 'XAF'
        ];
        $rate->express_rate = [
            'value' => $request->express,
            'currency' => 'XAF'
        ];
        $rate->save();

        return response([
            'success' => 1,
            'rate' => $rate
        ]);
    }

    public function storeInterCityRates(Request $request)
    {
        $request->validate([
            'dep_city'=>'required',
            'arr_city'=>'required',
            'good_type_id'=>'required',
            'regular'=>'required',
            'express'=>'required',
        ]);

        $test = IntercityRate::where('from_city_id',$request->dep_zone)->where('to_city_id',$request->arr_zone)->where('good_type_id',$request->good_type_id)->first();

        if ($test) {
            return response([
                'success' => 0,
                'message' => 'Rates already set'
            ]);
        }

        $rate = new IntercityRate();
        $rate->from_city_id = $request->dep_city;
        $rate->to_city_id = $request->arr_city;
        $rate->good_type_id = $request->good_type_id;
        $rate->regular_rate = [
            'value' => $request->regular,
            'currency' => 'XAF'
        ];
        $rate->express_rate = [
            'value' => $request->express,
            'currency' => 'XAF'
        ];
        $rate->save();

        return response([
            'success' => 1,
            'rate' => $rate
        ]);
    }


    public function updateInterzoneRates(Request $request)
    {
        $request->validate([
            'id'=>'required',
            'dep_zone'=>'required',
            'arr_zone'=>'required',
            'regular'=>'required',
            'express'=>'required',
        ]);


        $rate = Interzonerate::find($request->id);

        if ($rate) {
            return response([
                'success' => 0,
                'message' => 'Rates Not found'
            ]);
        }

        $rate->from_zone_id = $request->dep_zone;
        $rate->to_zone_id = $request->arr_zone;
        $rate->regular_rate = [
            'value' => $request->regular,
            'currency' => 'XAF'
        ];
        $rate->express_rate = [
            'value' => $request->express,
            'currency' => 'XAF'
        ];
        $rate->save();

        return response([
            'success' => 1,
            'rate' => $rate
        ]);
    }

    public function updateInterCityRates(Request $request)
    {
        $request->validate([
            'id'=>'required',
            'dep_city'=>'required',
            'arr_city'=>'required',
            'good_type_id'=>'required',
            'regular'=>'required',
            'express'=>'required',
        ]);

        $rate = Interzonerate::find($request->id);

        if ($rate) {
            return response([
                'success' => 0,
                'message' => 'Rates already set'
            ]);
        }

        $rate->from_city_id = $request->dep_city;
        $rate->to_city_id = $request->arr_city;
        $rate->good_type_id = $request->good_type_id;
        $rate->regular_rate = [
            'value' => $request->regular,
            'currency' => 'XAF'
        ];
        $rate->express_rate = [
            'value' => $request->express,
            'currency' => 'XAF'
        ];
        $rate->save();

        return response([
            'success' => 1,
            'rate' => $rate
        ]);
    }

    public function deleteInterCityRates($id)
    {
        $zone = InterCityRate::find($id);
        $zone->delete();
        return response([
            'success' => 1,
            'message' => 'Deleted successfully',
        ]);
    }

    public function deleteInterZoneRates($id)
    {
        $zone = Interzonerate::find($id);
        $zone->delete();
        return response([
            'success' => 1,
            'message' => 'Deleted successfully',
        ]);
    }

}
