<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use App\Models\City;
use App\Models\Country;

class CitiesController extends Controller
{
    //
    public function index(Request $request)
    {
        if ($request->country_id==null) {
            $cities = City::with(['state','country'])->orderBy('name','ASC')->paginate(100);
        }else {
            $cities = City::where('country_id',$request->country_id)->with(['state','country'])->orderBy('name','ASC')->paginate(100);

        }
        $countries= Country::orderBy('name','ASC')->get();
        return view('settings.areas.cities.index', compact(['cities','countries']));
    }

    public function store(Request $request)
    {
        try {

            $validator = Validator::make($request->all(), [
                'name' => 'required | string',
                'state_id' => 'required ',
                'country_id' => 'required ',
            ]);

            if ($validator->fails()) {
                return redirect()->back()->withInput()->with('error', $validator->messages()->first());
            };

            // store user information
            if ($this->save($request->only((new City())->getFillable()))) {
                return redirect()->back()->with('success', 'City created successfully!');
            } else {
                return redirect()->back()->with('error', 'Failed to create new City! Try again.');
            }
        } catch (\Exception $e) {
            $bug = $e->getMessage();

            return redirect()->back()->with('error', $bug);
        }
    }

    public function update(Request $request)
    {
        // update tenant info
        $validator = Validator::make($request->all(), [
            'id' => 'required',
            'name' => 'required | string',
            'state_id' => 'required ',
            'country_id' => 'required ',
        ]);
        if ($validator->fails()) {
            return redirect()->back()->withInput()->with('error', $validator->messages()->first());
        }

        try {
            $city = City::find($request->id);

            $data = $request->only((new City())->getFillable());

            $update = $this->save($data, $city); //$category->update($data);

            if ($update) {
                return redirect()->back()->with('success', 'City information updated successfully !');
            } else {
                return redirect()->back()->with('error', 'Failed to update the City! Try again.');
            }
        } catch (\Exception $e) {
            $bug = $e->getMessage();

            return redirect()->back()->with('error', $bug);
        }
    }

    public function delete($id)
    {
        $city = City::where('id', $id)->first();
        if ($city) {
            $city->delete();
            return redirect()->back()->with('success', 'city removed!');
        } else {
            return redirect()->back()->with('error', 'city not found');
        }
    }

    public function destroy($id)
    {
        $city = City::withTrashed()->where('id', $id)->first();
        if ($city) {
            $city->forceDelete();
            return redirect()->back()->with('success', 'City removed!');
        } else {
            return redirect()->back()->with('error', 'City not found');
        }
    }

    public function save($data, $city = null)
    {
        if(!$city){
            $city = new City();
        }

        $city->name = $data['name'];
        $city->state_id = $data['state_id'];
        $city->country_id = $data['country_id'];
        $city->save();

        return $city;
    }
}
