<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use App\Models\City;
use App\Models\Country;
use App\Models\Neighborhood;
use App\Models\State;

class NeighborhoodController extends Controller
{
    //
    public function index(Request $request)
    {
        if ($request->city_id==null) {
            $Neighborhoods = Neighborhood::with('city')->orderBy('name','ASC')->paginate(100);
        }else {
            $Neighborhoods = Neighborhood::where('city_id',$request->city_id)->with('city')->orderBy('name','ASC')->paginate(100);

        }
        $countries = Country::with('cities')->orderBy('name','ASC')->get();
        return view('settings.areas.Neighborhoods.index', compact(['Neighborhoods','countries']));
    }

    public function store(Request $request)
    {
        try {

            $validator = Validator::make($request->all(), [
                'name' => 'required | string',
                'city_id' => 'required ',
            ]);

            if ($validator->fails()) {
                return redirect()->back()->withInput()->with('error', $validator->messages()->first());
            };

            // store user information
            if ($this->save($request->only((new Neighborhood())->getFillable()))) {
                return redirect()->back()->with('success', 'Neighborhood created successfully!');
            } else {
                return redirect()->back()->with('error', 'Failed to create new Neighborhood! Try again.');
            }
        } catch (\Exception $e) {
            $bug = $e->getMessage();

            return redirect()->back()->with('error', $bug);
        }
    }

    public function update(Request $request)
    {
        // update tenant info
        $validator = Validator::make($request->all(), [
            'id' => 'required',
            'name' => 'required | string',
            'city_id' => 'required ',
        ]);
        if ($validator->fails()) {
            return redirect()->back()->withInput()->with('error', $validator->messages()->first());
        }

        try {
            $Neighborhood = Neighborhood::find($request->id);

            $data = $request->only((new Neighborhood())->getFillable());

            $update = $this->save($data, $Neighborhood); //$category->update($data);

            if ($update) {
                return redirect()->back()->with('success', 'Neighborhood information updated successfully !');
            } else {
                return redirect('settings.Neighborhoods')->with('error', 'Failed to update the Neighborhood! Try again.');
            }
        } catch (\Exception $e) {
            $bug = $e->getMessage();

            return redirect()->back()->with('error', $bug);
        }
    }

    public function delete($id)
    {
        $Neighborhood = Neighborhood::where('id', $id)->first();
        if ($Neighborhood) {
            $Neighborhood->delete();
            return redirect()->back()->with('success', 'Neighborhood removed!');
        } else {
            return redirect()->back()->with('error', 'Neighborhood not found');
        }
    }

    public function destroy($id)
    {
        $Neighborhood = Neighborhood::withTrashed()->where('id', $id)->first();
        if ($Neighborhood) {
            $Neighborhood->forceDelete();
            return redirect()->back()->with('success', 'City removed!');
        } else {
            return redirect()->back()->with('error', 'City not found');
        }
    }

    public function save($data, $Neighborhood = null)
    {
        if(!$Neighborhood){
            $Neighborhood = new Neighborhood();
        }

        $Neighborhood->name = $data['name'];
        $Neighborhood->city_id = $data['city_id'];
        $Neighborhood->save();

        return $Neighborhood;
    }

    public function getCitiesByCountry(Request $request)
    {
        if (!$request->country_id) {
            $html = '<option value="">Select Country</option>';
        } else {
            $html = '';
            $cities = City::where('country_id', $request->country_id)->get();
            foreach ($cities as $city) {
                $html .= '<option value="'.$city->id.'">'.$city->name.'</option>';
            }
        }

        return response()->json(['html' => $html]);
    }
  public function getNeighborhoodsByCity(Request $request)
    {
        if (!$request->city_id) {
            $html = '<option value="">Select City</option>';
        } else {
            $html = '';
            $Neighborhoods = Neighborhood::where('city_id', $request->city_id)->get();
            foreach ($Neighborhoods as $Neighborhood) {
                $html .= '<option value="'.$Neighborhood->id.'">'.$Neighborhood->name.'</option>';
            }
        }

        return response()->json(['html' => $html]);
    }
    public function getStatesByCountry(Request $request)
        {
            if (!$request->country_id) {
                $html = '<option value="">Select State</option>';
            } else {
                $html = '';
                $states = State::where('country_id', $request->country_id)->get();
                foreach ($states as $state) {
                    $html .= '<option value="'.$state->id.'">'.$state->name.'</option>';
                }
            }

            return response()->json(['html' => $html]);
        }

}
