<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class AccountCreated extends Mailable
{
    use Queueable, SerializesModels;

    public $password;
    public $name;
    public $username;
    /**
     * Create a new message instance.
     *
     * @return void
     */
    public function __construct($password,$name,$username = null)
    {
        //
        $this->password = $password;
        $this->name = $name;
        if ($username != null) {
            $this->username = $username;
        }
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        return $this->from('tajiceasy@gmail.com','TAJICEASY')
        ->view('mail.new-account')
        ->with(['password' => $this->password,'name' => $this->name,'username' => $this->username]);
    }
}
