<?php

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Collection;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

/**
 * Class Country
 * 
 * @property int $id
 * @property string|null $code
 * @property string|null $name
 * @property int|null $phonecode
 * @property Carbon|null $created_at
 * @property Carbon|null $updated_at
 * @property string|null $deleted_at
 * 
 * @property Collection|City[] $cities
 * @property Collection|State[] $states
 *
 * @package App\Models
 */

class Country extends Model
{
	use SoftDeletes;
	protected $table = 'countries';

	protected $casts = [
		'phonecode' => 'int'
	];

	protected $fillable = [
		'code',
		'name',
		'phonecode'
	];

	public function cities()
	{
		return $this->hasMany(City::class);
	}

	// public function cities()
	// {
	// 	return $this->hasManyThrough(
	// 		City::class,
	// 		State::class,
	// 		'country_id',// Foreign key on the State table...
	// 		'state_id',// Foreign key on the city table...
	// 		'id',// local key on the countries table...
	// 		'id',// local key on the states table...
	// 		);
	// }
	public function states()
	{
		return $this->hasMany(State::class);
	}
}
