<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Laravel\Passport\HasApiTokens;
use Illuminate\Database\Eloquent\SoftDeletes;
use Spatie\Permission\Traits\HasRoles;

class DeliveryAgent extends Authenticatable
{
    use HasFactory;
    use SoftDeletes;
    use HasApiTokens, HasRoles;
    protected $hidden = [
        'password',
    ];

    public function city()
    {
        return $this->belongsTo(City::class,'city_id');
    }
    public function neighborhood()
    {
        return $this->belongsTo(Neighborhood::class,'neighborhood_id');
    }
    public function branch()
    {
        return $this->belongsTo(Branch::class,'branch_id');
    }
    
}
