<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class DeliveryJob extends Model
{
    use HasFactory;
    use SoftDeletes;

    public function job_orders()
    {
        return $this->belongsToMany(DeliveryOrder::class,'delivery_job_orders','delivery_job_id','delivery_order_id');
    }

    public function customer()
    {
        return $this->belongsTo(Customer::class,'customer_id');
    }

    public function job_cod_transaction()
    {
        return $this->hasMany(JobCodTransaction::class, 'delivery_job_id');
    }
}
