<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class DeliveryOrder extends Model
{
    use HasFactory;
    use SoftDeletes;

    protected $casts = [
        'parcel_gallery' => 'object',
    ];

    public function delivery_job()
    {
        return $this->belongsToMany(DeliveryJob::class,'delivery_job_orders','delivery_order_id','delivery_job_id');
    }

    public function sender()
    {
        return $this->belongsTo(CustomerSender::class,'customer_sender_id');
    }

    public function receiver()
    {
        return $this->belongsTo(CustomerReceiver::class,'customer_receiver_id');
    }

    public function good_type()
    {
        return $this->belongsTo(GoodType::class,'good_type_id');
    }
    public function customer()
    {
        return $this->belongsTo(Customer::class,'customer_id');
    }
    public function delivery_agent()
    {
        return $this->belongsToMany(DeliveryAgent::class,DeliveryAgentOrder::class,'delivery_order_id','delivery_agent_id');
    }

    public function delivery_agent_order()
    {
        return $this->hasMany(DeliveryAgentOrder::class);
    }


}
