<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class IntercityRate extends Model
{
    use HasFactory;
    use SoftDeletes;
    protected $casts = [
        'regular_rate' => 'object',
        'express_rate' => 'object',
    ];

    public function from_city()
    {
        return $this->belongsTo(City::class,'from_city_id');
    }

    public function to_city()
    {
        return $this->belongsTo(City::class,'to_city_id');
    }

    public function good_type()
    {
        return $this->belongsTo(GoodType::class,'good_type_id');
    }

}
