<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class JobCodTransaction extends Model
{
    use HasFactory;
    use SoftDeletes;

    public function delivery_job()
    {
        return $this->belongsTo(DeliveryJob::class,'delivery_job_id');
    }

    public function delivery_order()
    {
        return $this->belongsTo(DeliveryOrder::class,'delivery_order_id');
    }

    public function customer()
    {
        return $this->belongsTo(Customer::class,'customer_id');
    }

}
