<?php

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Neighborhood extends Model
{

/**
 * Class Category
 * 
 * @property int $id
 * @property string $name
 * @property int $city_id
 * @property Carbon|null $created_at
 * @property Carbon|null $updated_at
 * @property string|null $deleted_at
 * 
 *
 * @package App\Models
 */

use SoftDeletes;
protected $table = 'neighborhoods';

// protected $casts = [
//     'name' => 'object',
// ];

protected $fillable = [
    'name',
    'city_id',
];

    public function city()
    {
        return $this->belongsTo(City::class);
    }

    public function zones()
    {
        return $this->belongsToMany(Zone::class,'zone_neighborhoods','neighborhood_id','zone_id');
    }
}
