<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Zone extends Model
{
    use HasFactory;
    protected $casts = [
        'regular_rate' => 'object',
        'express_rate' => 'object',
    ];


    public function cities()
    {
        return $this->belongsTo(City::class,'city_id');
    }

    public function neighborhoods()
    {
        return $this->belongsToMany(Neighborhood::class,'zone_neighborhoods','zone_id','neighborhood_id');
    }
}
