<?php

namespace App\Providers;

use Illuminate\Foundation\Support\Providers\AuthServiceProvider as ServiceProvider;
use Illuminate\Support\Facades\Gate;
use Laravel\Passport\Passport;

class AuthServiceProvider extends ServiceProvider
{
    /**
     * The policy mappings for the application.
     *
     * @var array<class-string, class-string>
     */
    protected $policies = [
        'App\Models\Model' => 'App\Policies\ModelPolicy',
    ];

    /**
     * Register any authentication / authorization services.
     *
     * @return void
     */
    public function boot()
    {
        $this->registerPolicies();

        Passport::routes();
        //
        // define your roles and descriptions for each role 
        Passport::tokensCan([
            'admin' => 'Access Delivery Vue Js',
            'super_admin' => 'Access Delivery Vue Js',
            'manager' => 'Access Delivery Vue Js',
            'agent' => 'Access Mobile App',
        ]);
        //specify the default role that would be attached if a role is not explicitly requested for.
        Passport::setDefaultScope([
            'admin',
        ]);

    }
}
