<?php

use App\Models\Interzonerate;
use App\Models\Neighborhood;
use App\Models\Zone;

function sameZone($from_neighborhood, $to_neighborhood)
{
    $from_neighborhood = Neighborhood::find($from_neighborhood);
    $to_neighborhood = Neighborhood::find($to_neighborhood);
    if (!$from_neighborhood) {
        return ['zone'=>null,'message'=>'Unknown Sender Neighborhood','success'=>-1];
    }

    if (!$to_neighborhood) {
        return ['zone'=>null,'message'=>'Unknown Receiver Neighborhood','success'=>-1];
    }

    // get zone

    $from_neighborhood_zone = Neighborhood::with('zones')->where('id',$from_neighborhood->id)->first();
    $to_neighborhood_zone = Neighborhood::with('zones')->where('id',$to_neighborhood->id)->first();
    foreach ($from_neighborhood_zone->zones as $fromzones) {
        foreach ($to_neighborhood_zone->zones as $tozones) {
            if ($fromzones->id == $tozones->id) {
                return ['zone'=>$fromzones,'success'=>1];
            }
        }
    }

    return ['zone'=>null,'message'=>'zone not found','success'=>0];
}

// function getPricingZone($zone_id,$zone = null)
// {
//     if ($zone == null) {
//         $zone = Zone::find($zone_id);
//         if (!$zone) {
//             return ['zone'=>null,'message'=>'Unknown zone','success'=>0];
//         }
//     }
//     return ['zone'=>$zone,'message'=>'Unknown zone','success'=>0];
// }

function getPricingInterzone($from_neighborhood, $to_neighborhood)
{
    $from_neighborhood = Neighborhood::find($from_neighborhood);
    $to_neighborhood = Neighborhood::find($to_neighborhood);
    if (!$from_neighborhood) {
        return ['zone'=>null,'message'=>'Unknown Sender Neighborhood','success'=>-1];
    }

    if (!$to_neighborhood) {
        return ['zone'=>null,'message'=>'Unknown Receiver Neighborhood','success'=>-1];
    }

    $from_neighborhood_zone = Neighborhood::with('zones')->where('id',$from_neighborhood->id)->first();
    $to_neighborhood_zone = Neighborhood::with('zones')->where('id',$to_neighborhood->id)->first();

    if(sizeof($to_neighborhood_zone->zones) == 0){
        return ['message'=>'Delivery Neighborhood not assigned to yet zone yet','success'=>0];
    }
    if(sizeof($from_neighborhood_zone->zones) == 0){
        return ['message'=>'Sender Neighborhood not assigned to yet zone yet','success'=>0];
    }
    
    $prices = Interzonerate::where('from_zone_id',$from_neighborhood_zone->zones[0]->id)->where('to_zone_id',$to_neighborhood_zone->zones[0]->id)->first();

    if (!$prices) {
        return ['message'=>'Rates for these zones not set','success'=>0];
    }

    return ['prices'=>$prices,'success'=>1];
}

function generateRandomString($length = 10) {
    $characters = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
    $charactersLength = strlen($characters);
    $randomString = '';
    for ($i = 0; $i < $length; $i++) {
        $randomString .= $characters[rand(0, $charactersLength - 1)];
    }
    return $randomString;
}
