<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateStatesTable extends Migration
{
    public function up()
    {
        Schema::create('states', function (Blueprint $table) {

                $table->bigIncrements('id')->unsigned();
                $table->string('name',125);
                $table->unsignedBigInteger('country_id');
                $table->foreign('country_id')->references('id')->on('countries');
                $table->timestamps();
                $table->softDeletes();

        });
    }

    public function down()
    {
        Schema::dropIfExists('states');
    }
}
