<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateZonesTable extends Migration
{
    public function up()
    {
        Schema::create('zones', function (Blueprint $table) {

		$table->bigIncrements('id')->unsigned();
		$table->integer('city_id')->index();
		$table->string('name',255);
		$table->json('regular_rate');
		$table->json('express_rate');
		$table->tinyInteger('status')->default(0);
		$table->timestamp('created_at')->nullable();
		$table->timestamp('updated_at')->nullable();
		$table->timestamp('deleted_at')->nullable();

        });
    }

    public function down()
    {
        Schema::dropIfExists('zones');
    }
}