<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateInterzoneratesTable extends Migration
{
    public function up()
    {
        Schema::create('interzonerates', function (Blueprint $table) {

		$table->bigIncrements('id')->unsigned();
		$table->integer('from_zone_id')->index();
		$table->integer('to_zone_id')->index();
		$table->json('regular_rate');
		$table->json('express_rate');
		$table->tinyInteger('status')->default(0);
		$table->timestamp('created_at')->nullable();
		$table->timestamp('updated_at')->nullable();
		$table->timestamp('deleted_at')->nullable();

        });
    }

    public function down()
    {
        Schema::dropIfExists('interzonerates');
    }
}