<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateGoodTypesTable extends Migration
{
    public function up()
    {
        Schema::create('good_types', function (Blueprint $table) {

		$table->bigIncrements('id')->unsigned();
		$table->string('name');
		$table->text('description')->nullable();
		$table->tinyInteger('status')->default(0);
		$table->timestamp('created_at')->nullable();
		$table->timestamp('updated_at')->nullable();
		$table->timestamp('deleted_at')->nullable();

        });
    }

    public function down()
    {
        Schema::dropIfExists('good_types');
    }
}