<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateCustomersTable extends Migration
{
    public function up()
    {
        Schema::create('customers', function (Blueprint $table) {

		$table->bigIncrements('id')->unsigned();
		$table->string('first_name',255)->nullable();
		$table->string('last_name',255)->nullable();
		$table->string('email',255);
		$table->json('phone');
		$table->integer('country');
		$table->timestamp('created_at')->nullable();
		$table->timestamp('updated_at')->nullable();
		$table->timestamp('deleted_at')->nullable();

        });
    }

    public function down()
    {
        Schema::dropIfExists('customers');
    }
}