<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateCustomerReceiversTable extends Migration
{
    public function up()
    {
        Schema::create('customer_receivers', function (Blueprint $table) {

		$table->bigIncrements('id')->unsigned();
		$table->integer('customer_id')->index();
		$table->enum('type',['business','residential']);
		$table->string('name',255);
		$table->string('email',255);
		$table->json('phone');
		$table->integer('country')->index();
		$table->integer('city')->index();
		$table->integer('neighborhood')->index();
		$table->string('longitude',255)->nullable();
		$table->string('latitude',255)->nullable();
		$table->string('zipcode',255)->nullable();
		$table->tinyInteger('status')->default(0);
		$table->tinyInteger('default');
		$table->timestamp('created_at')->nullable();
		$table->timestamp('updated_at')->nullable();
		$table->timestamp('deleted_at')->nullable();

        });
    }

    public function down()
    {
        Schema::dropIfExists('customer_receivers');
    }
}