<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateDeliveryTrackingTable extends Migration
{
    public function up()
    {
        Schema::create('delivery_tracking', function (Blueprint $table) {

		$table->bigIncrements('id')->unsigned();
		$table->integer('delivery_order_id')->index();
		$table->integer('order_track');
		$table->integer('t_dest')->index();
		$table->integer('t_city')->index();
		$table->text('comments')->nullable();
		$table->date('t_date');
		$table->tinyInteger('status')->default(0);
		$table->integer('branch_id')->index();
		$table->integer('user_id')->index();

        });
    }

    public function down()
    {
        Schema::dropIfExists('delivery_tracking');
    }
}