<?php

use App\Http\Controllers\Api\AuthApiController;
use App\Http\Controllers\Api\BranchesApiController;
use App\Http\Controllers\Api\CitiesApiController;
use App\Http\Controllers\Api\CountriesApiController;
use App\Http\Controllers\Api\DeliveryOrderApiController;
use App\Http\Controllers\Api\GoodsTypeApiController;
use App\Http\Controllers\Api\NeighborhoodApiController;
use App\Http\Controllers\Api\ZonesApiController;
use App\Http\Controllers\Api\PriceApiController;
use App\Http\Controllers\Api\CustomerApiController;
use App\Http\Controllers\Api\DeliveryAgentsApiController;
use App\Http\Controllers\Api\DeliveryJobsApiController;
use App\Http\Controllers\Api\TransactionsApiController;
use App\Http\Controllers\Api\UserApiController;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

Route::middleware('auth:sanctum')->get('/user', function (Request $request) {
    return $request->user();
});
Route::middleware('auth:api')->post('/logout',[AuthApiController::class,'logout']);

Route::post('/login',[AuthApiController::class,'login']);
Route::post('/forgot-password',[AuthApiController::class,'forgotPassword']);

Route::group(['middleware' => ['auth:agent']], function(){});
Route::group(['middleware' => ['auth:admin']], function(){});
Route::group(['middleware' => ['auth:super_admin']], function(){});
Route::group(['middleware' => ['auth:manager']], function(){});

Route::get('/countries',[CountriesApiController::class,'index']);
Route::get('/cities',[CitiesApiController::class,'index']);
Route::get('/delivery-cities',[CitiesApiController::class,'getSupportedDeliveryCities']);
//
Route::get('/neighborhoods',[NeighborhoodApiController::class,'index']);
Route::get('/neighborhood/{id}',[NeighborhoodApiController::class,'neighborhood']);
Route::post('/store-neighborhood',[NeighborhoodApiController::class,'store']);
Route::post('/neighborhoods/update',[NeighborhoodApiController::class,'update']);
//
Route::get('/zones',[ZonesApiController::class,'index']);
Route::get('/zones/delete/{id}',[ZonesApiController::class,'delete']);
Route::get('/zones/show/{id}',[ZonesApiController::class,'show']);
Route::get('/zones-by-city/{city_id}',[ZonesApiController::class,'zonesByCity']);
Route::post('/store-zone',[ZonesApiController::class,'store']);
Route::post('/zones/update',[ZonesApiController::class,'update']);
Route::post('/neighborhoods-to-zone',[ZonesApiController::class,'assignNeighborhoodsToZone']);
//

Route::get('/interzone-rates',[ZonesApiController::class,'getInterzoneRates']);
Route::get('/interzone-rate/{id}',[ZonesApiController::class,'interzoneRate']);
Route::get('/interzone-rates/delete/{id}',[ZonesApiController::class,'deleteInterzoneRates']);
Route::post('/interzone-rates/store',[ZonesApiController::class,'storeInterzoneRates']);
Route::post('/interzone-rates/update',[ZonesApiController::class,'updateInterzoneRates']);
Route::get('/intercity-rates',[ZonesApiController::class,'getIntercityRates']);
Route::get('/intercity-rate/{id}',[ZonesApiController::class,'intercityRate']);
Route::get('/intercity-rates/delete/{id}',[ZonesApiController::class,'deleteIntercityRates']);
Route::post('/intercity-rates/store',[ZonesApiController::class,'storeIntercityRates']);
Route::post('/intercity-rates/update',[ZonesApiController::class,'updateIntercityRates']);
//
Route::get('/good-types',[GoodsTypeApiController::class,'index']);
Route::post('/good-types/store',[GoodsTypeApiController::class,'store']);
Route::post('/good-types/update',[GoodsTypeApiController::class,'update']);
Route::get('/good-type/{id}',[GoodsTypeApiController::class,'goodType']);
Route::get('/good-types/delete/{id}',[GoodsTypeApiController::class,'delete']);
//
Route::get('/delivery-cost',[PriceApiController::class,'index']);
//
Route::get('/check-customer/{id}',[CustomerApiController::class,'checkCustomer']);
Route::get('/customers',[CustomerApiController::class,'index']);
Route::post('/store-customer',[CustomerApiController::class,'store']);
//
Route::post('/store-order',[DeliveryOrderApiController::class,'store']);
Route::get('/delivery-orders',[DeliveryOrderApiController::class,'index']);
Route::get('/delivery-orders/{type}',[DeliveryOrderApiController::class,'orderTypes']);
Route::get('/delivery-order/{id}',[DeliveryOrderApiController::class,'show']);
//

Route::get('/delivery-jobs/{id}',[DeliveryJobsApiController::class,'index']);
Route::post('/delivery-jobs/store',[DeliveryJobsApiController::class,'store']);
Route::get('/delivery-jobs/show/{id}',[DeliveryJobsApiController::class,'show']);
Route::get('/delivery-jobs',[DeliveryJobsApiController::class,'allJobs']);
Route::post('/delivery-jobs/assign-job-orders',[DeliveryJobsApiController::class,'assignJobOrders']);

//
Route::get('/branches',[BranchesApiController::class,'index']);
Route::get('/branch/{id}',[BranchesApiController::class,'show']);
Route::post('/branches/store',[BranchesApiController::class,'store']);
Route::get('/branches/delete/{id}',[BranchesApiController::class,'delete']);
Route::post('/branches/update/{id}',[BranchesApiController::class,'update']);

//
Route::get('/create-roles',[AuthApiController::class,'createRoles']);
//
Route::get('/logout',[AuthApiController::class,'logout']);
Route::post('/store-user',[AuthApiController::class,'store']);
Route::get('/users/{role}',[AuthApiController::class,'index']);
Route::get('/user/{id}',[AuthApiController::class,'show']);
Route::get('/roles',[AuthApiController::class,'getRoles']);

//
Route::get('/delivery-agents',[DeliveryAgentsApiController::class,'index']);
Route::get('/delivery-agents/{id}',[DeliveryAgentsApiController::class,'show']);
Route::post('/delivery-agent/store',[DeliveryAgentsApiController::class,'store']);
Route::post('/delivery-agent/change-order-status',[DeliveryAgentsApiController::class,'changeOrderStatus']);
Route::get('/delivery-agent/orders/{type}',[DeliveryAgentsApiController::class,'orders']);
// Route::post('/delivery-agent/store',[DeliveryAgentsApiController::class,'store']);
Route::get('/invitations',[DeliveryAgentsApiController::class,'invitations']);
//
Route::get('/profile',[UserApiController::class,'profile']);
//
Route::get('/transactions/job-cod',[TransactionsApiController::class,'jobCodTrx']);
Route::get('/transactions/order-commissions',[TransactionsApiController::class,'orderCommissionsTrx']);
